
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Generate random data for heatmap simulating sentiment scores
data = np.random.rand(8, 12) * 2 - 1  # Sentiments ranging from -1 to 1
title = "Sentiment Analysis of Movie Reviews"
xlabel = "Time Periods"
ylabel = "Movie Genres"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a new figure
plt.figure(figsize=(10, 8))

# Set the title of the heatmap
plt.title(title, fontsize=16, fontweight='bold')

# Set the label for the x-axis
plt.xlabel(xlabel, fontsize=14)
plt.xticks(ticks=np.arange(0.5, 12.5), labels=[f'Q{i+1}' for i in range(12)], rotation=45)

# Set the label for the y-axis
plt.ylabel(ylabel, fontsize=14)
plt.yticks(ticks=np.arange(0.5, 8.5), labels=[
    'Action', 'Comedy', 'Drama', 'Horror', 'Romance', 'Sci-Fi', 'Thriller', 'Animation'], rotation=0)

# Create a heatmap using pcolor function
c = plt.pcolor(data, edgecolors="white", linewidths=1, cmap="RdYlGn", vmin=-1.0, vmax=1.0)

# Add a colorbar to the figure
cbar = plt.colorbar(c)
cbar.set_label('Sentiment Score', fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Display the figure with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_120.pdf", bbox_inches="tight")
