
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data in the heatmap
data = np.array(
    [
        [np.nan, 0.65, 0.50, 0.55, 0.45, 0.35],
        [0.65, np.nan, 0.60, 0.52, 0.47, 0.40],
        [0.50, 0.60, np.nan, 0.58, 0.44, 0.38],
        [0.55, 0.52, 0.58, np.nan, 0.49, 0.45],
        [0.45, 0.47, 0.44, 0.49, np.nan, 0.42],
        [0.35, 0.40, 0.38, 0.45, 0.42, np.nan],
    ]
)

# Labels for the rows and columns
row_labels = ["Christianity", "Islam", "Hinduism", "Buddhism", "Sikhism", "Judaism"]
col_labels = ["Christianity", "Islam", "Hinduism", "Buddhism", "Sikhism", "Judaism"]

# Text labels and chart title
xlabel = "Compared Religions"
ylabel = "Reference Religions"
title = "Similarity Scores Between Religions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the axes
fig, ax = plt.subplots(figsize=(8, 8))

# Create the heatmap with a new color map
cax = ax.matshow(data, cmap="coolwarm")

# Set the ticks
ax.set_xticks(np.arange(len(col_labels)))
ax.set_yticks(np.arange(len(row_labels)))

# Set the tick labels
ax.set_xticklabels(col_labels)
ax.set_yticklabels(row_labels)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=45, ha="left", rotation_mode="anchor")

# Move the row labels to the right side
ax.yaxis.tick_right()

# Title and axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title, pad=20)

# Loop over data dimensions and create text annotations
for i in range(len(row_labels)):
    for j in range(len(col_labels)):
        if not np.isnan(data[i, j]):
            text = ax.text(
                j, i, f"{data[i, j]:.2f}", ha="center", va="center", color="black"
            )

# Set the visibility of the spines
ax.spines["top"].set_visible(True)
ax.spines["right"].set_visible(True)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Set the visibility of the ticks with only the top and right axes
ax.xaxis.set_ticks_position("top")
ax.yaxis.set_ticks_position("right")

# Add a color bar to show the scale
cbar = fig.colorbar(cax, ax=ax, fraction=0.046, pad=0.04)
cbar.set_label('Similarity Score')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("heatmap_32.pdf", bbox_inches="tight")
