
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data in the heatmap: [articles, views, likes, shares, comments, subscribers]
data = np.array(
    [
        [120, 8000, 1500, 300, 2000, 500],
        [110, 7500, 1300, 250, 1900, 480],
        [130, 9000, 1600, 350, 2200, 520],
        [125, 8500, 1550, 325, 2100, 510],
        [115, 7800, 1400, 275, 1950, 490],
    ]
)

# Labels for rows and columns
row_labels = ["Source A", "Source B", "Source C", "Source D", "Source E"]
column_labels = ["Articles", "Views", "Likes", "Shares", "Comments", "Subscribers"]
title = "Media Engagement Metrics"
xlabel = "Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the matplotlib figure
f, ax = plt.subplots(figsize=(10, 7))

# Define a vibrant colormap
vibrant_cmap = [
    "#FF6361", "#FFA600", "#BC5090", "#58508D", "#003F5C", "#00CC96", "#2E91E5"
]
cmap = mcolors.LinearSegmentedColormap.from_list("vibrant_cmap", vibrant_cmap)

# Draw the heatmap
cax = ax.imshow(data, cmap=cmap)

# Set the title
ax.set_title(title, fontsize=20, fontweight='bold')

# Set labels for axes
ax.set_xlabel(xlabel, fontsize=16)
ax.set_xticks(range(len(column_labels)))
ax.set_xticklabels(column_labels, fontsize=14)
ax.set_yticks(range(len(row_labels)))
ax.set_yticklabels(row_labels, fontsize=14, rotation=0)

# Increase font size of the tick labels
ax.tick_params(axis="both", which="major", labelsize=14)

# Add the text annotations
for i in range(len(row_labels)):
    for j in range(len(column_labels)):
        text = ax.text(
            j, i, data[i, j], ha="center", va="center", color="white", fontsize=14, fontweight='bold'
        )

# Create colorbar
cbar = f.colorbar(cax, ax=ax)
cbar.ax.tick_params(labelsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to fit the figure size
plt.tight_layout()

# Show the plot
plt.savefig("heatmap_34.pdf", bbox_inches="tight")
