
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Placeholder data for confusion matrices
data_math = np.array([[35, 12, 3, 0], [6, 45, 4, 1], [1, 7, 28, 12], [0, 1, 3, 50]])
data_science = np.array([[38, 9, 1, 2], [5, 32, 10, 3], [3, 6, 20, 17], [0, 0, 6, 40]])
data_literature = np.array([[30, 15, 5, 2], [8, 35, 6, 1], [2, 8, 25, 15], [1, 2, 4, 48]])
data_history = np.array([[40, 7, 2, 0], [9, 30, 11, 4], [2, 10, 24, 14], [1, 1, 5, 41]])
data_geography = np.array([[29, 12, 3, 4], [7, 40, 5, 2], [1, 9, 25, 16], [0, 3, 6, 39]])
data_physics = np.array([[33, 10, 2, 3], [5, 31, 12, 6], [2, 7, 22, 19], [1, 0, 4, 45]])
data_chemistry = np.array([[32, 11, 4, 1], [6, 28, 15, 5], [3, 9, 23, 15], [2, 1, 5, 44]])
data_biology = np.array([[37, 8, 3, 0], [9, 26, 13, 6], [4, 7, 18, 20], [1, 0, 2, 50]])

# Titles for the subplots
titles = ["Math", "Science", "Literature", "History", "Geography", "Physics", "Chemistry", "Biology"]
xlabel = "Predicted Grade"
ylabel = "Actual Grade"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axes = plt.subplots(nrows=2, ncols=4, figsize=(14, 8))  # Adjusted for better spacing

# Function to create a single confusion matrix plot
def plot_confusion_matrix(ax, data, title):
    im = ax.imshow(data, interpolation="nearest", cmap="Blues")
    ax.figure.colorbar(im, ax=ax)
    ax.set(
        title=title,
        xlabel=xlabel,
        ylabel=ylabel,
        xticks=np.arange(data.shape[1]),
        yticks=np.arange(data.shape[0]),
    )
    # Loop over data dimensions and create text annotations.
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(j, i, data[i, j], ha="center", va="center", color="black", fontsize=10)

# Plot each confusion matrix
plot_confusion_matrix(axes[0, 0], data_math, titles[0])
plot_confusion_matrix(axes[0, 1], data_science, titles[1])
plot_confusion_matrix(axes[0, 2], data_literature, titles[2])
plot_confusion_matrix(axes[0, 3], data_history, titles[3])
plot_confusion_matrix(axes[1, 0], data_geography, titles[4])
plot_confusion_matrix(axes[1, 1], data_physics, titles[5])
plot_confusion_matrix(axes[1, 2], data_chemistry, titles[6])
plot_confusion_matrix(axes[1, 3], data_biology, titles[7])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the figure
plt.tight_layout()
plt.savefig("heatmap_43.pdf", bbox_inches="tight")
