
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation 
# ===================
import numpy as np

np.random.seed(0)
# Placeholder data for confusion matrices (sports domain)
data_basketball = np.array([[50, 10, 5, 5], [7, 40, 3, 10], [5, 3, 30, 7], [3, 2, 5, 40]])
data_football = np.array([[45, 5, 2, 8], [6, 35, 12, 7], [3, 10, 29, 10], [1, 4, 6, 35]])
data_tennis = np.array([[55, 12, 2, 3], [5, 38, 10, 7], [2, 4, 35, 6], [3, 5, 7, 40]])
data_baseball = np.array([[60, 15, 4, 1], [10, 50, 8, 2], [5, 10, 40, 3], [2, 8, 5, 55]])
data_swimming = np.array([[40, 12, 6, 4], [8, 30, 15, 5], [3, 7, 35, 10], [1, 5, 8, 40]])
data_volleyball = np.array([[50, 10, 5, 5], [5, 42, 7, 6], [6, 8, 40, 8], [3, 2, 4, 50]])
data_hockey = np.array([[58, 12, 5, 3], [10, 45, 10, 5], [4, 6, 43, 7], [2, 5, 3, 60]])
data_skiing = np.array([[65, 15, 4, 2], [12, 55, 6, 3], [5, 6, 54, 5], [3, 6, 2, 70]])

# Titles for the subplots
titles = ["Basketball", "Football", "Tennis", "Baseball", "Swimming", "Volleyball", "Hockey", "Skiing"]
xlabel = "Predicted Category"
ylabel = "True Category"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axes = plt.subplots(nrows=2, ncols=4, figsize=(14, 7))  # Adjusted for better fit

# New colormap for a vibrant sport theme
cmap = plt.cm.plasma

# Function to create a single confusion matrix plot
def plot_confusion_matrix(ax, data, title):
    im = ax.imshow(data, interpolation="nearest", cmap=cmap)
    ax.figure.colorbar(im, ax=ax)
    ax.set(
        title=title,
        xlabel=xlabel,
        ylabel=ylabel,
        xticks=np.arange(data.shape[1]),
        yticks=np.arange(data.shape[0]),
    )
    # Loop over data dimensions and create text annotations.
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(j, i, data[i, j], ha="center", va="center", color="white")

# Plot each confusion matrix
plot_confusion_matrix(axes[0, 0], data_basketball, titles[0])
plot_confusion_matrix(axes[0, 1], data_football, titles[1])
plot_confusion_matrix(axes[0, 2], data_tennis, titles[2])
plot_confusion_matrix(axes[0, 3], data_baseball, titles[3])
plot_confusion_matrix(axes[1, 0], data_swimming, titles[4])
plot_confusion_matrix(axes[1, 1], data_volleyball, titles[5])
plot_confusion_matrix(axes[1, 2], data_hockey, titles[6])
plot_confusion_matrix(axes[1, 3], data_skiing, titles[7])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the figure
plt.tight_layout()
plt.savefig("heatmap_44.pdf", bbox_inches="tight")
