
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)  # Using a different seed for new data
# Placeholder data for confusion matrices in the domain of communication
data_email = np.array([[45, 10, 3, 2], [4, 40, 8, 3], [2, 7, 35, 6], [1, 4, 5, 40]])
data_chat = np.array([[50, 5, 2, 1], [3, 46, 6, 2], [0, 4, 40, 6], [1, 2, 7, 42]])
data_video_conference = np.array([[60, 4, 1, 3], [2, 35, 8, 5], [1, 5, 45, 9], [0, 3, 6, 50]])
data_voice_call = np.array([[55, 7, 4, 2], [3, 43, 7, 5], [4, 2, 50, 6], [2, 3, 5, 52]])

# Titles for the subplots
titles = ["Email", "Chat", "Video Conference", "Voice Call"]
xlabel = "Predicted category"
ylabel = "Ground truth category"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axes = plt.subplots(nrows=1, ncols=4, figsize=(16, 4))  # Adjusted for a single row layout

# Updated color map and annotations
cmap = "coolwarm"

# Function to create a single confusion matrix plot
def plot_confusion_matrix(ax, data, title):
    im = ax.imshow(data, interpolation="nearest", cmap=cmap)
    ax.figure.colorbar(im, ax=ax)
    ax.set(
        title=title,
        xlabel=xlabel,
        ylabel=ylabel,
        xticks=np.arange(data.shape[1]),
        yticks=np.arange(data.shape[0]),
    )
    ax.set_xticklabels(['Email', 'Chat', 'VideoConf', 'Voice'], rotation=45, ha="right")
    ax.set_yticklabels(['Email', 'Chat', 'VideoConf', 'Voice'])
    # Loop over data dimensions and create text annotations.
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(j, i, data[i, j], ha="center", va="center", color="black", fontsize=8, fontweight='bold')

# Plot each confusion matrix
plot_confusion_matrix(axes[0], data_email, titles[0])
plot_confusion_matrix(axes[1], data_chat, titles[1])
plot_confusion_matrix(axes[2], data_video_conference, titles[2])
plot_confusion_matrix(axes[3], data_voice_call, titles[3])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the figure
plt.tight_layout()
plt.savefig("heatmap_45.pdf", bbox_inches="tight")
