
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for correlation coefficients in educational skills
data = np.array(
    [
        [1.00, 0.88, 0.85, 0.80, 0.76, 0.70],
        [0.88, 1.00, 0.78, 0.82, 0.74, 0.72],
        [0.85, 0.78, 1.00, 0.84, 0.81, 0.75],
        [0.80, 0.82, 0.84, 1.00, 0.77, 0.73],
        [0.76, 0.74, 0.81, 0.77, 1.00, 0.79],
        [0.70, 0.72, 0.75, 0.73, 0.79, 1.00],
    ]
)

labels = ["Reading", "Math", "Critical Thinking", "Science", "Writing", "History"]
title = "Correlation Coefficients Among Educational Skills"
xlabel = "Skills"
ylabel = "Skills"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Adjust the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Create the heatmap with a customized color scheme
cax = ax.matshow(data, cmap="YlGnBu")

# Adjust color bar width
cbar = fig.colorbar(cax, fraction=0.046, pad=0.04, ticks=[0.70, 0.75, 0.80, 0.85, 0.90, 0.95, 1.00])
cbar.ax.set_yticklabels(["0.70", "0.75", "0.80", "0.85", "0.90", "0.95", "1.00"])

# Set axis labels
ax.set_xticks(np.arange(len(labels)))
ax.set_yticks(np.arange(len(labels)))

# x label should be at the bottom
ax.xaxis.set_ticks_position("bottom")
ax.set_xticklabels(labels)
ax.set_yticklabels(labels)

# Set axis labels
ax.set_xlabel(xlabel, fontsize=12, labelpad=20)
ax.set_ylabel(ylabel, fontsize=12, labelpad=20)

# Display the correlation values in the cells
for i in range(len(labels)):
    for j in range(len(labels)):
        ax.text(j, i, f"{data[i, j]:.2f}", va="center", ha="center",
                color="white" if data[i, j] < 0.7 else "black", fontsize=10)

# Set title
ax.set_title(title, pad=20)

# Add grid lines
ax.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size and show the plot
fig.set_size_inches(10, 8)
fig.tight_layout()
plt.savefig("heatmap_49.pdf", bbox_inches="tight")
