
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for correlation coefficients in a geographical context
data = np.array(
    [
        [1.00, 0.85, 0.70, 0.65, 0.50, 0.55, 0.45, 0.60, 0.40],
        [0.85, 1.00, 0.75, 0.80, 0.65, 0.70, 0.60, 0.55, 0.50],
        [0.70, 0.75, 1.00, 0.90, 0.60, 0.65, 0.55, 0.50, 0.45],
        [0.65, 0.80, 0.90, 1.00, 0.75, 0.70, 0.65, 0.60, 0.55],
        [0.50, 0.65, 0.60, 0.75, 1.00, 0.85, 0.75, 0.70, 0.65],
        [0.55, 0.70, 0.65, 0.70, 0.85, 1.00, 0.80, 0.75, 0.60],
        [0.45, 0.60, 0.55, 0.65, 0.75, 0.80, 1.00, 0.85, 0.70],
        [0.60, 0.55, 0.50, 0.60, 0.70, 0.75, 0.85, 1.00, 0.80],
        [0.40, 0.50, 0.45, 0.55, 0.65, 0.60, 0.70, 0.80, 1.00],
    ]
)

labels = [
    "Pop Density", "Avg Income", "Urban Rate", "Edu Level",
    "Health Index", "Emp Rate", "Climate Index", "Tourism Rate", "Env Quality"
]
title = "Geographical Factor Correlations"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Adjust the figure size
fig, ax = plt.subplots(figsize=(12, 10))

# Create the heatmap
cax = ax.matshow(data, cmap="YlGnBu")

# Adjust color bar width and style
cbar = fig.colorbar(cax, fraction=0.046, pad=0.04, ticks=np.arange(0.4, 1.1, 0.1))
cbar.ax.set_yticklabels([f"{i:.1f}" for i in np.arange(0.4, 1.1, 0.1)])

# Set axis labels
ax.set_xticks(np.arange(len(labels)))
ax.set_yticks(np.arange(len(labels)))
ax.xaxis.set_ticks_position("bottom")
ax.set_xticklabels(labels, rotation=45, ha='right', fontsize=12)
ax.set_yticklabels(labels, fontsize=12)

# Display the correlation values in the cells
for i in range(len(labels)):
    for j in range(len(labels)):
        ax.text(
            j,
            i,
            f"{data[i, j]:.2f}",
            va="center",
            ha="center",
            color="black" if data[i, j] < 0.7 else "white",
            fontsize=10,
        )

# Set title
ax.set_title(title, pad=20, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size and show the plot
fig.set_size_inches(12, 10)
fig.tight_layout()
plt.savefig("heatmap_50.pdf", bbox_inches="tight")
