
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for similarity scores among art styles
data = np.array(
    [
        [1.00, 0.78, 0.65, 0.58, 0.82, 0.61, 0.47, 0.55, 0.39],
        [0.78, 1.00, 0.72, 0.63, 0.75, 0.57, 0.53, 0.49, 0.42],
        [0.65, 0.72, 1.00, 0.84, 0.71, 0.66, 0.59, 0.52, 0.44],
        [0.58, 0.63, 0.84, 1.00, 0.68, 0.70, 0.61, 0.55, 0.50],
        [0.82, 0.75, 0.71, 0.68, 1.00, 0.88, 0.65, 0.60, 0.56],
        [0.61, 0.57, 0.66, 0.70, 0.88, 1.00, 0.78, 0.71, 0.69],
        [0.47, 0.53, 0.59, 0.61, 0.65, 0.78, 1.00, 0.82, 0.77],
        [0.55, 0.49, 0.52, 0.55, 0.60, 0.71, 0.82, 1.00, 0.81],
        [0.39, 0.42, 0.44, 0.50, 0.56, 0.69, 0.77, 0.81, 1.00],
    ]
)

labels = ["Abstract", "Cubism", "Impressionism", "Surrealism", "Pop Art", "Minimalism", "Expressionism", "Futurism", "Realism"]
title = "Art Style Similarity Scores"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Adjust the figure size to match the optimal dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Create the heatmap with a sophisticated colormap
cax = ax.matshow(data, cmap="viridis")

# Adjust color bar width and customize ticks
cbar = fig.colorbar(
    cax,
    fraction=0.046,
    pad=0.04,
    ticks=[0.40, 0.50, 0.60, 0.70, 0.80, 0.90, 1.00],
)
cbar.ax.set_yticklabels(["0.40", "0.50", "0.60", "0.70", "0.80", "0.90", "1.00"])

# Set axis labels
ax.set_xticks(np.arange(len(labels)))
ax.set_yticks(np.arange(len(labels)))
ax.xaxis.set_ticks_position("bottom")
ax.set_xticklabels(labels, rotation=45, ha='right')
ax.set_yticklabels(labels)

# Display the similarity scores in the cells
for i in range(len(labels)):
    for j in range(len(labels)):
        ax.text(
            j,
            i,
            f"{data[i, j]:.2f}",
            va="center",
            ha="center",
            color="black" if data[i, j] < 0.7 else "white",
            fontsize=10,
        )

# Set the title
ax.set_title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size and show the plot
fig.set_size_inches(10, 8)
fig.tight_layout()
plt.savefig("heatmap_51.pdf", bbox_inches="tight")
