
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample financial data for demonstration
data_upper = np.random.rand(9, 16) * 100  # Data for revenue growth trends (upper subplot)
data_lower = np.random.rand(9, 16) * 100  # Data for profit margins (lower subplot)

# Common labels for both subplots
financial_terms = [
    "Q1", "Q2", "Q3", "Q4", 
    "Gross Revenue", 
    "Net Revenue", 
    "Operational Costs", 
    "Net Profit", 
    "EBITDA"
]
layers = list(range(16))

# Axes Limits and Labels
title = "Financial Metrics Analysis (Q1-Q4)"
xlabel_value = "Time Periods"
xticks_values = [0, 4, 8, 12, 15]
xticklabels = ["Start", "Q1", "Q2", "Q3", "Q4"]
yticks_values = range(len(financial_terms))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and two subplots
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 8))  # Adjust figsize for better readability

# Define a new color map
cmap_upper = plt.get_cmap("Greens")
cmap_lower = plt.get_cmap("Blues")

# First subplot - Revenue Growth Trends
im1 = ax1.imshow(data_upper, cmap=cmap_upper, aspect='auto')
ax1.set_title("Revenue Growth Trends")
ax1.set_yticks(range(len(financial_terms)))
ax1.set_yticklabels(financial_terms)
ax1.grid(True, linestyle='--', linewidth=0.5)

# Second subplot - Profit Margins
im2 = ax2.imshow(data_lower, cmap=cmap_lower, aspect='auto')
ax2.set_xlabel(xlabel_value)
ax2.set_xticks(xticks_values)
ax2.set_xticklabels(xticklabels)
ax2.set_yticks(yticks_values)
ax2.set_yticklabels(financial_terms)
ax2.grid(True, linestyle='--', linewidth=0.5)

# Add colorbars
cbar1 = fig.colorbar(im1, ax=ax1, orientation='vertical', fraction=0.046, pad=0.04)
cbar1.set_label('Revenue Growth (%)')
cbar2 = fig.colorbar(im2, ax=ax2, orientation='vertical', fraction=0.046, pad=0.04)
cbar2.set_label('Profit Margin (%)')

# ===================
# Part 4: Saving Output
# ===================
# Show the entire figure with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_57.pdf", bbox_inches="tight")
