
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the heatmap (Sales performance as percentages)
data = np.array(
    [
        [0.85, 0.9, 0.78, 0.92, 0.88],
        [0.75, 0.8, 0.67, 0.89, 0.77],
        [0.65, 0.7, 0.72, 0.76, 0.84],
        [0.55, 0.6, 0.64, 0.68, 0.73],
        [0.45, 0.5, 0.55, 0.62, 0.69],
    ]
)

# Labels for the axes
regions = ["North", "South", "East", "West", "Central"]
products = ["Product A", "Product B", "Product C", "Product D", "Product E"]
xlabel = "Regions"
ylabel = "Products"
title = "Sales Performance Heatmap"
cbar_labels = ["50%", "60%", "70%", "80%", "90%", "100%"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the heatmap
fig, ax = plt.subplots(figsize=(10, 8))  # Adjusting figure size
cax = ax.matshow(data, cmap="viridis")

# Set the ticks and labels
ax.set_xticks(np.arange(len(regions)))
ax.set_yticks(np.arange(len(products)))

# Adjust the tick label alignment
ax.tick_params(
    axis="x", which="both", bottom=True, top=False, labelbottom=True, labeltop=False
)
ax.tick_params(axis="y", which="both", right=False, left=False, labelleft=True)

# Set the labels for the x-axis and rotate them for better readability
ax.set_xticklabels(regions, rotation=45)

# Set the labels for the y-axis
ax.set_yticklabels(products)

# Add colorbar with the correct range
cbar = plt.colorbar(cax, ticks=[0.5, 0.6, 0.7, 0.8, 0.9, 1.0])
cbar.ax.set_yticklabels(cbar_labels)  # Set the colorbar labels

# Add labels for the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Add title to the plot
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout to add more space around the heatmap
plt.tight_layout()

# Show the plot
plt.savefig("heatmap_62.pdf", bbox_inches="tight")
