
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for Environmental Science domain
data = np.random.rand(10, 5) * 2 - 1  # Random data between -1 and 1
sectors = [
    "Forestry",
    "Marine Biology",
    "Air Quality",
    "Water Resources",
    "Biodiversity",
    "Climate Change",
    "Renewable Energy",
    "Waste Management",
    "Soil Health",
    "Urban Planning",
]
technologies = ["Solar Power", "Wind Energy", "Hydroelectric", "Geothermal", "Biomass"]

# Text label parameters
xlabel = "Technologies"
ylabel = "Environmental Sectors"
title = "Impact of Technologies on Environmental Sectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the heatmap
fig, ax = plt.subplots(figsize=(6, 10))  # Adjusting figure size
cax = ax.matshow(data, cmap="viridis", vmin=-1, vmax=1)

# Set axis labels
ax.set_xticks(np.arange(len(technologies)))
ax.set_yticks(np.arange(len(sectors)))
ax.set_xticklabels(technologies)
ax.set_yticklabels(sectors)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=270, ha="center")

# Add colorbar
cbar = plt.colorbar(cax, aspect=10.5)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("heatmap_72.pdf", bbox_inches="tight")
