
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data to mimic the picture
data = np.array(
    [
        [0, 2, 4, 6, 8, 10],
        [np.nan, 2, 4, 6, 8, 10],
        [np.nan, np.nan, 2, 4, 6, 8],
        [np.nan, np.nan, np.nan, 2, 4, 6],
        [np.nan, np.nan, np.nan, np.nan, 2, 4],
        [np.nan, np.nan, np.nan, np.nan, np.nan, 2],
    ]
)

colorbar_label = "Streaming Hours"
xlabel = "Week"
ylabel = "Show"
textstr = "Streaming Trends\nTotal Hours=50"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 8))

# Create the heatmap
cax = ax.matshow(data, cmap="viridis")

# Add colorbar
cbar = fig.colorbar(cax, label=colorbar_label, shrink=0.5)  # Add shrink parameter here

# Set axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Set axis ticks
ax.set_xticks(np.arange(6))
ax.set_yticks(np.arange(6))
ax.set_xticklabels([1, 2, 3, 4, 5, ""])
ax.set_yticklabels(["Show A", "Show B", "Show C", "Show D", "Show E", ""])

# Add text box
props = dict(
    boxstyle="round",
    facecolor="white",
    alpha=0.5,
)
ax.text(
    0.05,
    0.15,
    textstr,
    transform=ax.transAxes,
    fontsize=12,
    verticalalignment="top",
    bbox=props,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("heatmap_73.pdf", bbox_inches="tight")
