
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample health data representing increase in blood pressure levels (%) due to stress over time
data = np.array(
    [
        [10, 20, 30, 40, 50, 60],
        [np.nan, 15, 25, 35, 45, 55],
        [np.nan, np.nan, 20, 30, 40, 50],
        [np.nan, np.nan, np.nan, 25, 35, 45],
        [np.nan, np.nan, np.nan, np.nan, 30, 40],
        [np.nan, np.nan, np.nan, np.nan, np.nan, 35],
    ]
)
colorbar_label = "Increase in Blood Pressure (%)"
xlabel = "Duration of Stress (days)"
ylabel = "Stress Level"
title = "Impact of Stress on Blood Pressure"
textstr = "Study: Health Effects\nAverage Increase"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Create the heatmap
cax = ax.matshow(data, cmap="RdYlGn")

# Add colorbar
cbar = fig.colorbar(cax, label=colorbar_label, shrink=0.5)

# Set axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Set axis ticks
ax.set_xticks(np.arange(6))
ax.set_yticks(np.arange(6))
ax.set_xticklabels(["1", "3", "5", "7", "9", "11"])
ax.set_yticklabels(["Low", "Moderate", "High", "Very High", "Severe", "Critical"])

# Add text box
props = dict(
    boxstyle="round",
    facecolor="white",
    alpha=0.8,
)
ax.text(
    0.05,
    0.15,
    textstr,
    transform=ax.transAxes,
    fontsize=12,
    verticalalignment="top",
    bbox=props,
)

# Add title
plt.title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("heatmap_75.pdf", bbox_inches="tight")
