
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the heatmaps (randomly generated for demonstration purposes)
data_survey = np.random.rand(4, 4) * 2 - 1  # Correlation coefficients range from -1 to 1
data_interview = np.random.rand(4, 4) * 2 - 1
data_observation = np.random.rand(4, 4) * 2 - 1
data_experimental = np.random.rand(4, 4) * 2 - 1
titles = ["Survey", "Interview", "Observation", "Experimental"]
fig_title = "Psychological Study Methods"
xticklabels = ["Metric1", "Metric2", "Metric3", "Metric4"]
yticklabels = ["Metric1", "Metric2", "Metric3", "Metric4"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with subplots
fig, axs = plt.subplots(2, 2, figsize=(7, 6))


# Function to add text annotations
def add_annotations(ax, data):
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(j, i, f"{data[i, j]:.2f}", ha="center", va="center", color="black")


# Survey heatmap
im1 = axs[0, 0].imshow(data_survey, cmap="Blues", vmin=-1, vmax=1)
axs[0, 0].set_title(titles[0])
add_annotations(axs[0, 0], data_survey)

# Interview heatmap
im2 = axs[0, 1].imshow(data_interview, cmap="Greens", vmin=-1, vmax=1)
axs[0, 1].set_title(titles[1])
add_annotations(axs[0, 1], data_interview)

# Observation heatmap
im3 = axs[1, 0].imshow(data_observation, cmap="Purples", vmin=-1, vmax=1)
axs[1, 0].set_title(titles[2])
add_annotations(axs[1, 0], data_observation)

# Experimental heatmap
im4 = axs[1, 1].imshow(data_experimental, cmap="Oranges", vmin=-1, vmax=1)
axs[1, 1].set_title(titles[3])
add_annotations(axs[1, 1], data_experimental)

# Adjust layout and add overall title
fig.suptitle(fig_title, fontsize=16)

# Set tick labels
for ax in axs.flat:
    ax.set_xticks(np.arange(4))
    ax.set_yticks(np.arange(4))
    ax.set_xticklabels(xticklabels)
    ax.set_yticklabels(yticklabels)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to minimize white space
plt.tight_layout(rect=[0, 0, 0.9, 0.95])
# Save the figure to a file
plt.savefig("heatmap_82.pdf", bbox_inches="tight")
