
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Define the crop labels
crops = [
    "Wheat",
    "Rice",
    "Corn",
    "Cotton",
    "Soybeans",
    "Barley",
    "Oats",
    "Sorghum",
]

# Define the data for the original and adjusted values (land usage percentages)
original_values = [0.20, 0.15, 0.25, 0.10, 0.05, 0.10, 0.05, 0.10]
adjusted_values = [0.22, 0.14, 0.27, 0.08, 0.06, 0.09, 0.06, 0.08]
titles = ["Original Land Usage", "Adjusted Land Usage"]

# Annotation Texts
annotation_texts = ["{:.2f}".format(val) for val in original_values + adjusted_values]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for original and one for adjusted values)
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 8))

# Define the color palette
cmap = plt.get_cmap("YlGnBu")

# Plot heatmap for original values
im1 = ax1.imshow(pd.DataFrame([original_values], columns=crops), cmap=cmap)
ax1.set_title(titles[0])
ax1.set_xticks(range(len(crops)))
ax1.set_xticklabels(crops, rotation=45, ha="right")
ax1.set_yticks(range(1))
ax1.set_yticklabels([""], rotation=0)

# Add annotations for original values
for i in range(1):
    for j in range(len(crops)):
        ax1.text(
            j, i, f"{original_values[j]:.2f}", ha="center", va="center", color="black"
        )

# Plot heatmap for adjusted values
im2 = ax2.imshow(pd.DataFrame([adjusted_values], columns=crops), cmap=cmap)
ax2.set_title(titles[1])
ax2.set_xticks(range(len(crops)))
ax2.set_xticklabels(crops, rotation=45, ha="right")
ax2.set_yticks(range(1))
ax2.set_yticklabels([""], rotation=0)

# Add annotations for adjusted values
for i in range(1):
    for j in range(len(crops)):
        ax2.text(
            j, i, f"{adjusted_values[j]:.2f}", ha="center", va="center", color="black"
        )

# Display the figure
plt.subplots_adjust(hspace=-0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("heatmap_89.pdf", bbox_inches="tight")
