
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Creating dummy data based on the newly chosen domain - Politics
data_Party_A = pd.DataFrame(
    {
        "Policy Strength": ["#45", "#32", "#60", "#52"],
        "Popularity": ["#55", "#70", "#40", "#50"],
        "Funding": ["#80", "#63", "#74", "#68"],
    }
)

data_Party_B = pd.DataFrame(
    {
        "Policy Strength": ["#35", "#42", "#50", "#72"],
        "Popularity": ["#65", "#75", "#60", "#58"],
        "Funding": ["#70", "#60", "#82", "#76"],
    }
)

# Creating a function to convert the string indices to numeric values for plotting
def convert_to_numeric(cell):
    return int(cell.replace("#", ""))

# Convert the dataframes to numeric values
data_Party_A_numeric = data_Party_A.applymap(convert_to_numeric)
data_Party_B_numeric = data_Party_B.applymap(convert_to_numeric)

# Axes Limits and Labels
ax1_title = "Party A Rankings"
ax1_ylabel = "Rank"
ax2_title = "Party B Rankings"

# Label settings
xlabels = ["Policy Strength", "Popularity", "Funding"]
ylabels = ["Category 1", "Category 2", "Category 3", "Category 4"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the heatmap using matplotlib with increased linewidths for separation
fig, (ax1, ax2) = plt.subplots(
    ncols=2, figsize=(10, 5), gridspec_kw={"width_ratios": [1, 1], "wspace": 0.3}
)

# Setting the color map to match the political theme: Reds for Party A, Blues for Party B
cmap_Party_A = plt.get_cmap("Reds")
cmap_Party_B = plt.get_cmap("Blues")

# Heatmap for Party A with increased cell borders
im1 = ax1.imshow(data_Party_A_numeric, cmap=cmap_Party_A)
ax1.set_title(ax1_title)
ax1.set_ylabel(ax1_ylabel)
ax1.set_xticks(range(len(data_Party_A.columns)))
ax1.set_xticklabels(xlabels, rotation=45, ha="right")
ax1.set_yticks(range(len(data_Party_A.index)))
ax1.set_yticklabels(ylabels, rotation=0)

# Add annotations for Party A
for i in range(len(data_Party_A.index)):
    for j in range(len(data_Party_A.columns)):
        ax1.text(j, i, data_Party_A.iloc[i, j], ha="center", va="center", color="black")

# Heatmap for Party B with increased cell borders
im2 = ax2.imshow(data_Party_B_numeric, cmap=cmap_Party_B)
ax2.set_title(ax2_title)
ax2.set_xticks(range(len(data_Party_B.columns)))
ax2.set_xticklabels(xlabels, rotation=45, ha="right")
ax2.set_yticks(range(len(data_Party_B.index)))
ax2.set_yticklabels(ylabels, rotation=0)

# Add annotations for Party B
for i in range(len(data_Party_B.index)):
    for j in range(len(data_Party_B.columns)):
        ax2.text(j, i, data_Party_B.iloc[i, j], ha="center", va="center", color="black")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("heatmap_95.pdf", bbox_inches="tight")
