
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Creating a new dataset related to economics, representing ranks of different economic indicators for various countries
data_economics = {
    "Country": ["USA", "Germany", "China", "India"],
    "GDP Rank": ["#1", "#4", "#2", "#5"],
    "Inflation Rank": ["#6", "#8", "#7", "#3"],
    "Unemployment Rank": ["#9", "#2", "#8", "#12"],
}

data_economics_reversed = {
    "Country": ["India", "China", "Germany", "USA"],
    "GDP Rank": ["#5", "#2", "#4", "#1"],
    "Inflation Rank": ["#3", "#7", "#8", "#6"],
    "Unemployment Rank": ["#12", "#8", "#2", "#9"],
}

# Convert to DataFrame
data_economics_df = pd.DataFrame(data_economics).set_index("Country")
data_economics_reversed_df = pd.DataFrame(data_economics_reversed).set_index("Country")

# Creating a function to convert the string indices to numeric values for plotting
def convert_to_numeric(cell):
    return int(cell.replace("#", ""))

# Convert the dataframes
data_economics_numeric = data_economics_df.applymap(convert_to_numeric)
data_economics_reversed_numeric = data_economics_reversed_df.applymap(convert_to_numeric)

# Axes Limits and Labels
ax1_title = "Economic Indicators"
ax1_ylabel = "Countries"
ax2_title = "Reversed Economic Indicators"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the heatmap using matplotlib with increased linewidths for separation
fig, (ax1, ax2) = plt.subplots(
    ncols=2, figsize=(10, 5), gridspec_kw={"width_ratios": [1, 1], "wspace": 0.3}
)

# Setting a custom color map appropriate for the domain
cmap_custom1 = plt.get_cmap("YlGnBu")
cmap_custom2 = plt.get_cmap("YlOrRd")

# Heatmap for Economic Indicators with increased cell borders
im1 = ax1.imshow(data_economics_numeric, cmap=cmap_custom1)
ax1.set_title(ax1_title)
ax1.set_ylabel(ax1_ylabel)
ax1.set_xticks(range(len(data_economics_df.columns)))
ax1.set_xticklabels(data_economics_df.columns, rotation=45)
ax1.set_yticks(range(len(data_economics_df.index)))
ax1.set_yticklabels(data_economics_df.index, rotation=0)

# Add annotations for Economic Indicators
for i in range(len(data_economics_df.index)):
    for j in range(len(data_economics_df.columns)):
        ax1.text(j, i, data_economics_df.iloc[i, j], ha="center", va="center", color="black")

# Heatmap for Reversed Economic Indicators with increased cell borders
im2 = ax2.imshow(data_economics_reversed_numeric, cmap=cmap_custom2)
ax2.set_title(ax2_title)
ax2.set_xticks(range(len(data_economics_reversed_df.columns)))
ax2.set_xticklabels(data_economics_reversed_df.columns, rotation=45)
ax2.set_yticks(range(len(data_economics_reversed_df.index)))
ax2.set_yticklabels(data_economics_reversed_df.index, rotation=0)

# Add annotations for Reversed Economic Indicators
for i in range(len(data_economics_reversed_df.index)):
    for j in range(len(data_economics_reversed_df.columns)):
        ax2.text(j, i, data_economics_reversed_df.iloc[i, j], ha="center", va="center", color="black")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("heatmap_96.pdf", bbox_inches="tight")
