
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Define the data for the original and adjusted values (annual precipitation levels in cm)
original_values = [85.4, 120.8, 95.3, 75.6, 110.0, 105.0, 98.7, 89.5]
adjusted_values = [90.0, 125.0, 100.0, 80.0, 115.0, 110.0, 103.0, 93.0]  # After adjustment

# Labels and text content
cities = ['City A', 'City B', 'City C', 'City D', 'City E', 'City F', 'City G', 'City H']
xlabel = 'Cities'
ylabel = 'Precipitation (cm)'
title1 = 'Original Annual Precipitation Levels'
title2 = 'Adjusted Annual Precipitation Levels'
suptitle = 'Annual Precipitation Levels Comparison (Original vs Adjusted)'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for original and one for adjusted values)
fig, axs = plt.subplots(2, 1, figsize=(12, 5), sharex=True)

# Define the color palette for precipitation
cmap = plt.get_cmap("Blues")

# Plot heatmap for original values
im1 = axs[0].imshow(pd.DataFrame([original_values], index=[""]), cmap=cmap)
axs[0].set_xticks(np.arange(len(cities)))
axs[0].set_xticklabels(cities, rotation=45, ha="right")
axs[0].set_yticks([])
axs[0].set_title(title1)

# Add annotations for original values
for j in range(len(original_values)):
    color = "white" if original_values[j] > np.mean(original_values) else "black"
    axs[0].text(j, 0, f"{original_values[j]:.1f}", ha="center", va="center", color=color)

# Plot heatmap for adjusted values
im2 = axs[1].imshow(pd.DataFrame([adjusted_values], index=[""]), cmap=cmap)
axs[1].set_xticks(np.arange(len(cities)))
axs[1].set_xticklabels(cities, rotation=45, ha="right")
axs[1].set_yticks([])
axs[1].set_title(title2)

# Add annotations for adjusted values
for j in range(len(adjusted_values)):
    color = "white" if adjusted_values[j] > np.mean(adjusted_values) else "black"
    axs[1].text(j, 0, f"{adjusted_values[j]:.1f}", ha="center", va="center", color=color)

# ===================
# Part 4: Saving Output
# ===================
# Add a super title for the figure
fig.suptitle(suptitle, fontsize=16)

# Display the figure with tight layout to minimize white space
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("heatmap_97.pdf", bbox_inches="tight")
