
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Define the data for the original and adjusted values
religions = ["Christianity", "Islam", "Hinduism", "Buddhism", "Judaism"]
original_values = [0.60, 0.25, 0.10, 0.03, 0.02]  # Region A
adjusted_values = [0.55, 0.30, 0.08, 0.05, 0.02]  # Region B

# Text labels
xlabel = "Religions"
ylabel = "Percentage Population"
title_original = "Region A: Religious Distribution"
title_adjusted = "Region B: Religious Distribution"
supertitle = "Comparison of Religious Distributions in Two Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for original and one for adjusted values)
fig, axs = plt.subplots(2, 1, figsize=(10, 6), sharex=True, sharey=True)

# Define the color palette
cmap_original = plt.get_cmap("Blues")
cmap_adjusted = plt.get_cmap("Greens")

# Plot heatmap for original values
im1 = axs[0].imshow(pd.DataFrame([original_values], index=[""], columns=religions), cmap=cmap_original)
axs[0].set_xticks(range(len(religions)))
axs[0].set_xticklabels(religions)
axs[0].set_yticks([])
axs[0].set_title(title_original)

# Add annotations for original values
for j in range(len(original_values)):
    color = "white" if original_values[j] > 0.5 else "black"
    axs[0].text(j, 0, f"{original_values[j]:.2f}", ha="center", va="center", color=color)

# Plot heatmap for adjusted values
im2 = axs[1].imshow(pd.DataFrame([adjusted_values], index=[""], columns=religions), cmap=cmap_adjusted)
axs[1].set_xticks(range(len(religions)))
axs[1].set_xticklabels(religions)
axs[1].set_yticks([])
axs[1].set_title(title_adjusted)

# Add annotations for adjusted values
for j in range(len(adjusted_values)):
    color = "white" if adjusted_values[j] > 0.5 else "black"
    axs[1].text(j, 0, f"{adjusted_values[j]:.2f}", ha="center", va="center", color=color)

# Overall figure adjustments
plt.suptitle(supertitle)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Display the figure with tight layout to minimize white space
plt.tight_layout(rect=[0, 0, 1, 0.96])  # Adjust for super title
plt.savefig("heatmap_98.pdf", bbox_inches="tight")
