
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for the approval and disapproval ratings
approval_ratings = [0.45, 0.52, 0.55, 0.60, 0.35, 0.50, 0.70, 0.65]
disapproval_ratings = [0.40, 0.35, 0.30, 0.25, 0.55, 0.40, 0.25, 0.30]

# Text labels and parameters
titles = ["Approval Ratings", "Disapproval Ratings"]
xlabel = "Political Figures"
ylabel = "Ratings"
fig_suptitle = "Political Approval and Disapproval Ratings"
filepath = "heatmap_23_9.pdf"

# Define figure labels for annotation
figure_labels = ["Figure " + str(i + 1) for i in range(len(approval_ratings))]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for approval and one for disapproval ratings)
fig, axs = plt.subplots(2, 1, figsize=(10, 4), sharex=True)
plt.suptitle(fig_suptitle)

# Define the color palettes
cmap_approval = plt.get_cmap("Blues")
cmap_disapproval = plt.get_cmap("Reds")

# Plot heatmap for approval ratings
im1 = axs[0].imshow(pd.DataFrame([approval_ratings], index=[""]), cmap=cmap_approval)
axs[0].set_title(titles[0])
axs[0].set_xticks(range(len(figure_labels)))
axs[0].set_xticklabels(figure_labels)
axs[0].set_yticks([])

# Add annotations for approval ratings
for j in range(len(approval_ratings)):
    color = "white" if approval_ratings[j] > np.mean(approval_ratings) else "black"
    axs[0].text(j, 0, f"{approval_ratings[j]:.2f}", ha="center", va="center", color=color)

# Plot heatmap for disapproval ratings
im2 = axs[1].imshow(pd.DataFrame([disapproval_ratings], index=[""]), cmap=cmap_disapproval)
axs[1].set_title(titles[1])
axs[1].set_xticks(range(len(figure_labels)))
axs[1].set_xticklabels(figure_labels)
axs[1].set_yticks([])

# Add annotations for disapproval ratings
for j in range(len(disapproval_ratings)):
    color = "white" if disapproval_ratings[j] > np.mean(disapproval_ratings) else "black"
    axs[1].text(j, 0, f"{disapproval_ratings[j]:.2f}", ha="center", va="center", color=color)

# ===================
# Part 4: Saving Output
# ===================
# Display the figure with tight layout to minimize white space
plt.tight_layout(rect=[0, 0, 1, 0.96])  # Adjust rect to account for suptitle
plt.savefig("heatmap_99.pdf", bbox_inches="tight")
