
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulating data for Email Response Time
sizes = np.linspace(300, 100, 6, dtype=int)  # Generate sizes from 300 to 100
data = [
    np.abs(np.random.normal(loc, scale, size)) for loc, scale, size in zip(
        [0.5, 0.7, 0.65, 0.55, 0.6, 0.8],  # Different means for each team
        [0.3, 0.2, 0.25, 0.15, 0.2, 0.3],  # Different scales for each team
        sizes
    )
]

labels = ["Sales", "Support", "Development", "HR", "Marketing", "Finance"]
xlabel = "Email Response Time (hours)"
ylabel = "Frequency"
xlim = [0, 2]
xticks = [0.0, 0.5, 1.0, 1.5, 2.0]
bins = 30

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram plot
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]

plt.figure(figsize=(10, 8))
plt.hist(
    data,
    bins=bins,
    stacked=True,
    edgecolor="black",
    linewidth=1.2,
    color=colors,
    label=labels,
)

# Set background color to white
ax = plt.gca()
ax.set_facecolor("white")

# Labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(xlim)
plt.xticks(xticks)
plt.title("Email Response Time by Team")

handles, labels = plt.gca().get_legend_handles_labels()

# Reverse handles and labels
handles = handles[::-1]
labels = labels[::-1]

plt.legend(handles, labels)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the plot to match the original image's dimensions
plt.tight_layout()
plt.savefig("hist_21.pdf", bbox_inches="tight")
