
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulating financial returns data
sizes = np.linspace(300, 100, 6, dtype=int)  # Generate sizes from 300 to 100
data = [
    np.random.normal(0, 1, size) for size in sizes
]  # Generate data with mean 0 and standard deviation 1

# Labels and settings
labels = [
    "Stock A",
    "Stock B",
    "Stock C",
    "Stock D",
    "Stock E",
    "Stock F",
]
xlabel = "Daily Returns"
ylabel = "Frequency"
title = "Distribution of Daily Returns for Various Stocks"
xlim = [-4, 4]
xticks = [-4, -3, -2, -1, 0, 1, 2, 3, 4]
bins = 30

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram plot
colors = ["#73d216", "#4e9a06", "#c4a000", "#ef2929", "#cc0000", "#a40000"]

plt.figure(figsize=(10, 8))
plt.hist(
    data,
    bins=bins,
    stacked=True,
    edgecolor="black",
    linewidth=1.2,
    color=colors,
    label=labels,
)

# Set background color to white
ax = plt.gca()
ax.set_facecolor("white")

# Labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.xlim(xlim)
plt.xticks(xticks)
handles, labels = plt.gca().get_legend_handles_labels()

# Reverse handles and labels
handles = handles[::-1]
labels = labels[::-1]

plt.legend(handles, labels)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("hist_22.pdf", bbox_inches="tight")
