
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for income distribution in two regions
region_a_income = np.random.lognormal(mean=10, sigma=0.5, size=1000)
region_b_income = np.random.lognormal(mean=10.5, sigma=0.6, size=1000)

# Define the number of bins and bin edges for consistent bin width
bins = np.histogram(np.hstack((region_a_income, region_b_income)), bins=20)[1]
labels = ["Region A", "Region B"]
xticks = [0, 50000, 100000, 150000, 200000]
xlabel = "Income ($)"
ylabel = "Count"
title = "Income Distribution in Two Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(8, 6))

# Create the histograms without stacking
plt.hist(
    region_a_income,
    bins=bins,
    color="#4e79a7",
    label=labels[0],
    edgecolor="white",
    linewidth=1.2,
    alpha=0.7,
    zorder=2,
)
plt.hist(
    region_b_income,
    bins=bins,
    color="#f28e2b",
    label=labels[1],
    edgecolor="white",
    linewidth=1.2,
    alpha=0.7,
    zorder=3,
)

# Set the background color
plt.gca().set_facecolor("#f9f9f9")

# Set the scale of y-axis to logarithmic
plt.yscale("log")

# Set the x-axis ticks
plt.xticks(xticks)
plt.tick_params(axis="x", length=0)

# Add light grey grid lines and place them behind the bars (zorder=0)
plt.grid(color="#dcdcdc", linestyle="-", linewidth=0.8, zorder=0)

# Set the y-axis ticks and remove all line markings (spines)
plt.yticks([1, 10, 100, 1000])
plt.tick_params(axis="y", length=0)
for spine in plt.gca().spines.values():
    spine.set_visible(False)  # Remove all the spines

# remove small dash on y-axis
plt.tick_params(axis="y", which="minor", length=0)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add legend with title
plt.legend(title="Regions")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Show the plot
plt.savefig("hist_28.pdf", bbox_inches="tight")
