
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data
adventure_freq = np.random.exponential(scale=0.02, size=1000)
romance_freq = np.random.exponential(scale=0.01, size=1000)

# Define the number of bins and bin edges for consistent bin width
bins = np.histogram(np.hstack((adventure_freq, romance_freq)), bins=15)[1]
labels = ["Adventure", "Romance"]
xticks = [0.00, 0.05, 0.10, 0.15]
xlabel = "Theme Frequency"
ylabel = "Count"
title = "Theme Frequency in Literature"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(6, 5))

# Create the histograms without stacking
plt.hist(
    adventure_freq,
    bins=bins,
    color="#8B4513",  # SaddleBrown
    label=labels[0],
    edgecolor="white",
    linewidth=0.6,
    alpha=0.6,
    zorder=2,
)
plt.hist(
    romance_freq,
    bins=bins,
    color="#DAA520",  # GoldenRod
    label=labels[1],
    edgecolor="white",
    linewidth=0.6,
    alpha=0.6,
    zorder=3,
)

# Set the background color
plt.gca().set_facecolor("#FAF0E6")  # Linen

# Set the scale of y-axis to logarithmic
plt.yscale("log")

# Set the x-axis ticks
plt.xticks(xticks)
plt.tick_params(axis="x", length=0)

# Add white grid lines and place them behind the bars (zorder=0)
plt.grid(color="white", linestyle="-", linewidth=1.5, zorder=0)

# Set the y-axis ticks and remove all line markings (spines)
plt.yticks([1, 10, 100])
plt.tick_params(axis="y", length=0)
for spine in plt.gca().spines.values():
    spine.set_visible(False)  # Remove all the spines

# remove small dash on y-axis
plt.tick_params(axis="y", which="minor", length=0)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add legend with title
plt.legend(title="Theme")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Show the plot
plt.savefig("hist_29.pdf", bbox_inches="tight")
