
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for agriculture domain
crop_a_yield = np.random.normal(40, 10, 1000)
crop_b_yield = np.random.normal(30, 12, 1000)

# Define bins aligned for both histograms
bins = np.histogram(np.hstack((crop_a_yield, crop_b_yield)), bins=30)[1]
labels = ["Crop A", "Crop B"]
xlabel = "Yield (tonnes per hectare)"
ylabel = "Number of Fields"
title = "Distribution of Crop Yields"
legendlabels = ["Crop A Yield", "Crop B Yield"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(6, 4))  # Adjusted to a slightly larger size for better clarity

# Plot histograms
ax.hist(
    crop_a_yield,
    bins=bins,
    color="#76c893",  # Green color for Crop A
    edgecolor="#004d00",  # Dark green edges
    linewidth=1.2,
    label=legendlabels[0],
    align="mid",
    histtype="stepfilled",
    alpha=0.6,
)
ax.hist(
    crop_b_yield,
    bins=bins,
    color="#d3a35d",  # Brown color for Crop B
    edgecolor="#7a3e00",  # Dark brown edges
    linewidth=1.2,
    label=legendlabels[1],
    align="mid",
    histtype="stepfilled",
    alpha=0.6,
)

# Set title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Add grid for better readability
ax.grid(True, linestyle='--', alpha=0.5)

# Add legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Save the plot
plt.savefig("hist_30.pdf", bbox_inches="tight")
