
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data - Entertainment Domain
movie_durations = np.random.normal(120, 30, 1000) # durations in minutes
tv_show_durations = np.random.normal(45, 10, 1000) # durations in minutes

# Define bins aligned for both histograms
bins = np.histogram(np.hstack((movie_durations, tv_show_durations)), bins=30)[1]
labels = ["Movies", "TV Shows"]
xlabel = "Duration (Minutes)"
ylabel = "Number of Releases"
title = "Distribution of Movie and TV Show Durations"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(7, 4))

# Calculate the histogram data for each set and plot them
ax.hist(
    movie_durations,
    bins=bins,
    color="#00bcd4",
    edgecolor="#00796b",
    linewidth=1.2,
    label=labels[0],
    align="mid",
    histtype="stepfilled",
    alpha=0.7,
)
ax.hist(
    tv_show_durations,
    bins=bins,
    color="#ff9800",
    edgecolor="#e65100",
    linewidth=1.2,
    label=labels[1],
    align="mid",
    histtype="stepfilled",
    alpha=0.7,
)

# To show the overlapping areas
ax.hist(
    movie_durations,
    bins=bins,
    color="#00bcd4",
    edgecolor="#00796b",
    linewidth=1.2,
    alpha=0.7,
    align="mid",
    histtype="stepfilled",
)
ax.hist(
    tv_show_durations,
    bins=bins,
    color="#ff9800",
    edgecolor="#e65100",
    linewidth=1.2,
    alpha=0.7,
    align="mid",
    histtype="stepfilled",
)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Save the plot
plt.savefig("hist_31.pdf", bbox_inches="tight")
