
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for agriculture
yield_irrigated = np.random.normal(8, 1.5, 1000)  # Irrigated yield data
yield_non_irrigated = np.random.normal(4, 2, 1000)  # Non-irrigated yield data

# Define bins aligned for both histograms
bins = np.histogram(np.hstack((yield_irrigated, yield_non_irrigated)), bins=30)[1]
labels = ["Irrigated", "Non-Irrigated"]
xlabel = "Agricultural Yield (tons/acre)"
ylabel = "Number of Farms"
title = "Comparison of Agricultural Yields"
legendlabels = ["Irrigated", "Non-Irrigated"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(
    figsize=(7, 5)
)  # Adjusted size for better visibility

# Plot data with optimized styles
ax.hist(
    yield_irrigated,
    bins=bins,
    color="#4CAF50",
    edgecolor="#2E7D32",
    linewidth=1.2,
    label=labels[0],
    align="mid",
    histtype="stepfilled",
    alpha=0.7,
)
ax.hist(
    yield_non_irrigated,
    bins=bins,
    color="#FFCC80",
    edgecolor="#EF6C00",
    linewidth=1.2,
    label=labels[1],
    align="mid",
    histtype="stepfilled",
    alpha=0.7,
)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add legend
ax.legend(labels=legendlabels)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Save the plot
plt.savefig("hist_32.pdf", bbox_inches="tight")
