
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate synthetic stock returns data (daily returns as a normal distribution with slight skew)
data = np.random.normal(loc=0.001, scale=0.02, size=10000)
data = data[data < 0.1]  # Limiting the data to a certain range for better visualization

xlabel = "Daily Return"
ylabel = "Frequency"
binslist = [50, 50]
mean_return = np.mean(data)
median_return = np.median(data)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(6, 4))

# Show grid with some transparency
plt.grid(True, linestyle="-", linewidth=0.5, color="#000000", alpha=0.1)

# Create the histogram
plt.hist(data, bins=binslist[0], color="#66c2a5", alpha=0.7, label='Returns Distribution')

# Create the histogram with histtype='step' for edge-only bars
plt.hist(
    data,
    bins=binslist[1],
    color="#66c2a5",
    edgecolor="#1b9e77",
    histtype="step",
    linewidth=1.2,
)

# Add a vertical line for the mean return
plt.axvline(mean_return, color="#fc8d62", linestyle="--", linewidth=1.5, label='Mean Return')

# Set the title and labels
plt.title("Distribution of Daily Stock Returns")
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("hist_35.pdf", bbox_inches="tight")
