
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new data for household income distribution
# Simulating data: mean income is higher in urban areas, with wider dispersion
urban_areas_income = np.random.normal(loc=50000, scale=15000, size=1000)
rural_areas_income = np.random.normal(loc=30000, scale=10000, size=1000)
labels = ["Urban Areas", "Rural Areas"]
xlabel = "Annual Household Income (USD)"
bins = 50

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to an appropriate dimension
plt.figure(figsize=(8, 5))

# Plot histograms with stacked bars
plt.hist(
    [urban_areas_income, rural_areas_income],
    bins=bins,
    stacked=True,
    label=labels,
    color=["#1f77b4", "#ff7f0e"],  # Custom color palette
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel("Number of Households")
plt.title("Household Income Distribution in Urban and Rural Areas")
plt.legend()

# Adjust x-axis range to appropriately display the new data
plt.xlim(left=0, right=100000)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_38.pdf", bbox_inches="tight")
