
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
np.random.seed(0)
approval_ratings = np.array([0.1, 0.15, 0.22, 0.3, 0.45, 0.55, 0.65, 0.75, 0.85])
trust_levels = np.array([0.12, 0.18, 0.28, 0.35, 0.5, 0.45, 0.6, 0.7, 0.8])
calibration_error = 0.25
text = f"Calibration Error:\n{calibration_error}"

# Axes Limits and Labels
xlabel_value = "Approval Rating"
ylabel_value = "Trust Level"
title = "Political Approval vs Trust"
xlim_values = [0, 1]
ylim_values = [0, 1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(8, 8))

# Plot histogram using plt.hist and specify bins
plt.hist(approval_ratings, bins=9, weights=trust_levels, color="skyblue", edgecolor="black")

# Add diagonal dashed line
plt.plot([0, 1], [0, 1], "k--", linestyle="--", linewidth=1, color="darkred")

# Add text for calibration error
plt.text(0.08, 0.85, text, color="blue", fontsize=18)

# Set labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title)

# Adjust x and y axis limits to match the reference picture
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_40.pdf", bbox_inches="tight")
