
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New Sample Data for Population Distribution by Age Group
age_groups = [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100]  # age bins
population_counts = [1_500_000, 2_000_000, 2_500_000, 3_000_000, 2_800_000, 2_200_000, 1_800_000, 1_200_000, 
                     800_000, 400_000]  # population in each age group

# Axes Limits and Labels
xlabel_value = "Age Groups"
ylabel_value = "Population"
title_value = "Population Distribution by Age Group"
xlim_values = [0, 100]
ylim_values = [0, 3_500_000]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a histogram
plt.figure(figsize=(8, 6))  # Adjusted size for better visualization
plt.hist(age_groups[:-1], bins=age_groups, weights=population_counts, color="#1f77b4", edgecolor='black', alpha=0.7)

# Set the labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title_value)

# Remove ticks on both axes
plt.tick_params(axis="both", which="both", length=0)

# Set the range for the axes
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("hist_42.pdf", bbox_inches="tight")
