
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulated data for tourism (number of tourists per month)
# Dataset for Destination A
tourists_A = np.random.normal(20000, 4000, 10000)
# Dataset for Destination B
tourists_B = np.random.normal(30000, 5000, 10000)
binslist = [50, 50]
titles = ["Destination A", "Destination B"]
rangelist = [(0, 40000), (0, 50000)]
# Labels
xlabel = "Number of Tourists"
ylabel = "Frequency"
suptitle = "Tourism Data for Two Destinations"
legendlabels = ["Tourists"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(10, 7), gridspec_kw={"hspace": 0.3})
# Colors
colors = ["#2a9d8f", "#e76f51"]

# First histogram (Destination A)
axs[0].hist(tourists_A, bins=binslist[0], range=rangelist[0], color=colors[0])
axs[0].set_title(titles[0])
axs[0].set_xlabel(xlabel)
axs[0].set_ylabel(ylabel)
axs[0].legend(legendlabels, loc="upper right")

# Second histogram (Destination B)
axs[1].hist(tourists_B, bins=binslist[1], range=rangelist[1], color=colors[1])
axs[1].set_title(titles[1])
axs[1].set_xlabel(xlabel)
axs[1].set_ylabel(ylabel)
axs[1].legend(legendlabels, loc="upper right")

# Set super title for the whole figure
fig.suptitle(suptitle)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95]) # Adjust layout to fit the suptitle
plt.savefig("hist_47.pdf", bbox_inches="tight")
