
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data for communication domain
# Simulate signal strength data from two communication channels
data1 = np.random.normal(75, 10, 500)  # Channel 1
data2 = np.random.normal(60, 15, 500)  # Channel 2

# Text labels and parameters
labels = ["Channel 1 Signal", "Channel 2 Signal"]
xlabel = "Signal Strength (dBm)"
ylabel = "Frequency"
titlelist = [
    "(a) Scenario 1",
    "(b) Scenario 2",
    "(c) Scenario 3",
    "(d) Scenario 4",
]
suptitle = "Signal Strength Distribution Across Different Scenarios"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(2, 2, figsize=(12, 10))
colors = ["#ff7f0e", "#1f77b4"]  # Vibrant color scheme

# Plot histograms for each subplot
for i, (ax, title) in enumerate(zip(axs.flatten(), titlelist)):
    ax.hist(
        data1,
        bins=30,
        density=True,
        alpha=0.7,
        color=colors[0],
        edgecolor="black",
        linewidth=0.5,
        label=labels[0]
    )
    ax.hist(
        data2,
        bins=30,
        density=True,
        alpha=0.7,
        color=colors[1],
        edgecolor="black",
        linewidth=0.5,
        label=labels[1]
    )
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.set_title(title, fontsize=12)
    if i == 0:  # Place legend on the first subplot
        ax.legend()

# Set a super title for the entire figure
plt.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("hist_51.pdf", bbox_inches="tight")
