
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new data for a tech domain context (example: response times and user engagement metrics)
data1 = np.random.normal(2, 0.5, 600)  # Response Times
data2 = np.random.normal(3, 0.6, 800)  # User Engagement Metrics

# Labels and titles for the new domain
labels = ["Response Times", "User Engagement"]
xlabel = "Metric Value"
ylabel = "Density"
titlelist = [
    "(a) Initial Phase",
    "(b) Mid Phase",
    "(c) Final Phase",
    "(d) Summary"
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size
fig, axs = plt.subplots(2, 2, figsize=(12, 10))

# Modern color scheme
colors = ["#FF6F61", "#6B5B95"]

# Plot histograms for each subplot
for i, ax in enumerate(axs.flatten()):
    ax.hist(
        data1,
        bins=30,
        density=True,
        alpha=0.7,
        color=colors[0],
        label=labels[0],
        edgecolor="black",
        linewidth=0.7,
    )
    ax.hist(
        data2,
        bins=30,
        density=True,
        alpha=0.7,
        color=colors[1],
        label=labels[1],
        edgecolor="black",
        linewidth=0.7,
    )
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.legend()

# Set titles for each subplot
axs[0, 0].set_title(titlelist[0])
axs[0, 1].set_title(titlelist[1])
axs[1, 0].set_title(titlelist[2])
axs[1, 1].set_title(titlelist[3])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_52.pdf", bbox_inches="tight")
