
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate random data for demonstration in media domain
# Assuming data represents the engagement percentages with different media platforms
netflix_data = np.random.normal(25, 5, 500)  # Engagement with Netflix
youtube_data = np.random.normal(30, 7, 500)  # Engagement with YouTube

# Labels and styles
labels = ["Netflix", "YouTube"]
xlabel = "Engagement Time (Hours/Week)"
ylabel = "Density"
titlelist = [
    "(a) Engagement with Netflix",
    "(b) Engagement with YouTube",
    "(c) Comparison in Age Group 18-24",
    "(d) Comparison in Age Group 25-34",
]

# Additional style parameters
colors = ["#FF6347", "#4682B4"]
edgecolor = "black"
linewidth = 0.5

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Plot histograms for each subplot
for i, ax in enumerate(axs.flatten()):
    ax.hist(
        netflix_data,
        bins=30,
        density=True,
        alpha=0.6,
        color=colors[0],
        label=labels[0],
        edgecolor=edgecolor,
        linewidth=linewidth,
    )
    ax.hist(
        youtube_data,
        bins=30,
        density=True,
        alpha=0.6,
        color=colors[1],
        label=labels[1],
        edgecolor=edgecolor,
        linewidth=linewidth,
    )
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.legend()

# Set titles for each subplot
axs[0, 0].set_title(titlelist[0])
axs[0, 1].set_title(titlelist[1])
axs[1, 0].set_title(titlelist[2])
axs[1, 1].set_title(titlelist[3])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_53.pdf", bbox_inches="tight")
