
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate random data for illustration purposes (representing PM2.5 levels)
cities_data = {
    "City A": np.random.normal(20, 5, 1000),
    "City B": np.random.normal(22, 7, 1000),
    "City C": np.random.normal(18, 6, 1000),
    "City D": np.random.normal(25, 5, 1000),
    "City E": np.random.normal(30, 8, 1000),
    "City F": np.random.normal(28, 6, 1000),
    "City G": np.random.normal(26, 7, 1000),
    "City H": np.random.normal(24, 5, 1000),
}

# Define the titles for each subplot
titles = [
    "City A PM2.5 Levels",
    "City B PM2.5 Levels",
    "City C PM2.5 Levels",
    "City D PM2.5 Levels",
    "City E PM2.5 Levels",
    "City F PM2.5 Levels",
    "City G PM2.5 Levels",
    "City H PM2.5 Levels",
]

# Define the colors for each subplot
colors = ["forestgreen", "darkgreen", "mediumblue", "darkblue", "seagreen", "teal", "dodgerblue", "navy"]
xlabel = "PM2.5 (µg/m³)"
ylabel = "Density"
bins = 30
xvline = 25  # Typical threshold for unhealthy air quality

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(7, 8))  # Adjusted to match 720x864 dimensions

# Create subplots
for i, (city, data) in enumerate(cities_data.items()):
    plt.subplot(4, 2, i + 1)
    plt.hist(data, bins=bins, density=True, alpha=0.6, color=colors[i], range=(0, 50))
    plt.title(titles[i])
    plt.xlabel(xlabel)
    plt.ylabel(ylabel)
    plt.axvline(
        x=xvline, color="k", linestyle="--", linewidth=1
    )  # Typical unhealthy threshold
    plt.grid(True, linestyle='--', alpha=0.5)  # Adding grid for readability

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and show the plot
plt.tight_layout(pad=0.4, w_pad=0.5, h_pad=1.0)  # Adjusted padding for tighter layout
plt.savefig("hist_54.pdf", bbox_inches="tight")
