
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Setting a seed for reproducibility
np.random.seed(0)

# Simulating temperature data for two cities over a year (365 days)
temps_city_a = np.random.normal(15, 5, 365)
temps_city_b = np.random.normal(25, 8, 365)

# Define bins aligned for both histograms with a little space between bars
bin_width = 1  # Adjust as necessary for clear separation
bins = np.histogram(np.hstack((temps_city_a, temps_city_b)), bins=30)[1]

# Labels and metadata for the plot
labels = ["City A Temperatures", "City B Temperatures"]
xlabel = "Temperature (°C)"
ylabel = "Frequency"
title = "Temperature Distribution Comparison: City A vs City B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust size if needed

# Plot histograms with custom colors
ax.hist(
    temps_city_a,
    bins=bins,
    alpha=0.7,
    label=labels[0],
    color="#1f77b4",  # Blue for cooler temperatures
    edgecolor="black",
    linestyle='-',  # Solid line
    linewidth=1.2
)
ax.hist(
    temps_city_b,
    bins=bins,
    alpha=0.7,
    label=labels[1],
    color="#ff7f0e",  # Orange for warmer temperatures
    edgecolor="black",
    linestyle=':',  # Dotted line
    linewidth=1.2
)

# Set labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Add title
ax.set_title(title)  # Adjust title to reflect the data

# Add grid
ax.grid(color="#d3d3d3", linestyle="-", linewidth=1, zorder=0)

# Add legend at a new location
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Save the plot
plt.savefig("hist_60.pdf", bbox_inches="tight")
