
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate new sample data for population demographics
region_a_ages = np.random.beta(2, 5, 1000) * 100  # Skewed to younger ages
region_b_ages = np.random.normal(50, 15, 1000)  # Uniform mix of ages, centered around 50

# Define bins with suitable width
bin_width = 5
bins = np.arange(0, 101, bin_width)

# Text labels and parameters
labels = ["Region A: Suburban", "Region B: Urban"]
xlabel = "Age"
ylabel = "Population Count"
title = "Age Distribution Comparison between Suburban and Urban Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # Adjust size for better readability

# Plot histograms using plt.hist() with adjustments for clarity
ax.hist(
    region_a_ages,
    bins=bins,
    alpha=0.7,
    label=labels[0],
    color="#3498db",
    edgecolor="black",
)
ax.hist(
    region_b_ages,
    bins=bins,
    alpha=0.7,
    label=labels[1],
    color="#e74c3c",
    edgecolor="black",
)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add grid for better readability
ax.grid(color="#cccccc", linestyle="--", linewidth=0.7, zorder=0)

# Add legend
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping
plt.tight_layout()

# Save the plot
plt.savefig("hist_62.pdf", bbox_inches="tight")
