
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Generate normally distributed data
data = np.random.normal(loc=75, scale=10, size=10000)

# Axes Limits and Labels
title = "Histogram of Student Test Scores"
xlabel_value = "Test Scores"
ylabel_value = "Number of Students"
# Highlight the median of the data
median = np.median(data)
annotation_text = f"Median: {median:.2f}"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 7))

# Enable the grid
plt.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)

# Histogram of the data
n, bins, patches = plt.hist(data, bins=30, color="#8EC0E4", edgecolor="#20639B", alpha=0.7)

# Median line
plt.axvline(median, color="#ED553B", linestyle="dashed", linewidth=2)

# Adjust the median text position to not overlap the bars when possible
median_text_position = max(n) * 0.9
for bin_edge, count in zip(bins, n):
    if bin_edge > median and count < median_text_position:
        # Place the text above the median position
        median_text_position = count
        break
plt.text(median + 0.5, median_text_position, annotation_text, color="#ED553B")

# Title and labels relevant to database statistics
plt.title(title, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout
plt.tight_layout()

plt.savefig("hist_63.pdf", bbox_inches="tight")
