
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for blood pressure readings
exercise_group = np.random.normal(loc=120, scale=10, size=1000)
no_exercise_group = np.random.normal(loc=140, scale=15, size=1000)

# Labels and Plot Types
hist_label = ["Regular Exercise", "No Exercise"]

# Axes Limits and Labels
xlabel_value = "Blood Pressure (mmHg)"
ylabel_value = "Frequency"
title = "Blood Pressure Distribution by Exercise Habits"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(6, 5))

# Plot histograms with stacked bars, modified colors, and alpha for transparency
plt.hist(
    [exercise_group, no_exercise_group],
    bins=50,
    stacked=True,
    label=hist_label,
    color=["#77DD77", "#FFB347"],  # Green and Orange
    alpha=0.7,
)

# Add labels, title, and modify the style of the labels
plt.xlabel(xlabel_value, color="#333333")
plt.ylabel(ylabel_value, color="#333333")
plt.title(title)

# Modify the legend style and position to lower center
plt.legend(frameon=True, loc="lower center", ncol=2, bbox_to_anchor=(0.5, -0.25))

# Adjust x-axis range and add some space at the beginning of the x-axis
plt.xlim(left=min(exercise_group.min(), no_exercise_group.min()) - 5, right=max(exercise_group.max(), no_exercise_group.max()) + 5)

# Add grid with lighter color and set behind the histograms
plt.grid(color="grey", linestyle="--", linewidth=0.5, alpha=0.7)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_68.pdf", bbox_inches="tight")
