
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulating data for energy consumption (in MWh)
sizes = np.linspace(300, 100, 6, dtype=int)  # Generate sizes from 300 to 100
data = [np.abs(np.random.normal(0, 0.3, size)) for size in sizes]  # Generate data

labels = ["Solar", "Wind", "Hydro", "Nuclear", "Coal", "Gas"]

# Adjusting the data and labels for the second histogram
# Simulating data for energy production (in MWh)
modified_sizes = np.linspace(300, 200, 6, dtype=int)  # Generate sizes from 300 to 200
modified_data = [
    np.abs(np.random.normal(0, 0.28, size)) for size in modified_sizes
]  # Increase variance to 0.28

modified_labels = ["Prod. " + label for label in labels]  # Prepend 'Prod. ' to each label

# Text labels and other parameters
xlabels = ["Energy Consumption (MWh)", "Energy Production (MWh)"]
ylabels = ["Frequency", "Frequency"]
xlims = [[0, 1], [0, 1]]
xticks = [[0.0, 0.2, 0.4, 0.6, 0.8, 1.0], [0.0, 0.2, 0.4, 0.6, 0.8, 1.0]]
binslist = [30, 30]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1 x 2 subplot for the updated plots
fig, axs = plt.subplots(nrows=1, ncols=2, figsize=(16, 7))

# Custom colors for the energy domain
colors = ["#FFA07A", "#20B2AA", "#778899", "#FFD700", "#8B0000", "#00CED1"]

# First subplot (Energy Consumption)
axs[0].hist(
    data,
    bins=binslist[0],
    stacked=True,
    edgecolor="black",
    linewidth=1.2,
    color=colors,
    label=labels,
)
axs[0].set_xlabel(xlabels[0])
axs[0].set_ylabel(ylabels[0])
axs[0].set_xlim(xlims[0])
axs[0].set_xticks(xticks[0])
axs[0].set_facecolor("white")
handles, labels = axs[0].get_legend_handles_labels()
handles = handles[::-1]
labels = labels[::-1]
axs[0].legend(handles, labels, loc="upper right")

# Second subplot (Energy Production)
axs[1].hist(
    modified_data,
    bins=binslist[1],
    stacked=True,
    edgecolor="black",
    linewidth=1.2,
    color=colors,
    label=modified_labels,
)
axs[1].set_xlabel(xlabels[1])
axs[1].set_ylabel(ylabels[1])
axs[1].set_xlim(xlims[1])
axs[1].set_xticks(xticks[1])
axs[1].set_facecolor("white")
handles, labels = axs[1].get_legend_handles_labels()
handles = handles[::-1]
labels = labels[::-1]
axs[1].legend(handles, labels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("hist_69.pdf", bbox_inches="tight")
