
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New business data
regions = [
    "North America",
    "Europe",
    "Asia",
    "South America",
    "Africa"
]

# Generating plausible sales data for different regions
sales_data = np.array(
    [
        np.random.randint(200, 700, 100),  # North America
        np.random.randint(150, 550, 100),  # Europe
        np.random.randint(100, 450, 100),  # Asia
        np.random.randint(50, 300, 100),  # South America
        np.random.randint(30, 200, 100),  # Africa
    ]
)

xlabel = "Number of Sales"
ylabel = "Frequency"
title = "Histogram of Product Sales Across Different Regions"
# Histogram bins
bins = np.linspace(0, 750, 30)  # Adjusted bin range to accommodate new data

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 8))
# Define distinct colors for the business theme
business_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]
for i, region in enumerate(regions):
    plt.hist(
        sales_data[i],
        bins=bins,
        alpha=0.6,
        color=business_colors[i % len(business_colors)],
        label=region,
        edgecolor="black",  # Adding edge color to improve readability
    )

plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)
plt.legend(loc="upper right", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("hist_72.pdf", bbox_inches="tight")

