
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)

# Data for the Education domain
education_categories = [
    "Number of Enrolled Students",
    "Number of Graduating Students",
    "Number of Dropouts",
    "Number of Teachers",
    "Number of New Programs",  # Additional categories
]

# Generate synthetic data for each category
data_distributions = {
    "Number of Enrolled Students": np.random.normal(loc=300, scale=50, size=100),
    "Number of Graduating Students": np.random.normal(loc=200, scale=30, size=100),
    "Number of Dropouts": np.random.normal(loc=50, scale=10, size=100),
    "Number of Teachers": np.random.normal(loc=60, scale=15, size=100),
    "Number of New Programs": np.random.normal(loc=20, scale=5, size=100),
}

xlabel = "Number of Individuals"
ylabel = "Frequency"
title = "Histogram of Educational Statistics Across Various Categories"
bins = np.linspace(0, 400, 30)  # Adjusted bin range to accommodate new data

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 8))
# Define new distinct cooler colors for the education domain
cooler_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

for i, category in enumerate(education_categories):
    plt.hist(
        data_distributions[category],
        bins=bins,
        alpha=0.6,
        color=cooler_colors[i % len(cooler_colors)],
        label=category,
    )

plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("hist_74.pdf", bbox_inches="tight")

