
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data simulating word lengths in characters
classic_lit = np.random.normal(7.5, 2.5, 10000)
modern_lit = np.random.normal(5.5, 2.0, 10000)  # More variation in word lengths
classic_lit_variation = np.random.normal(8.0, 3.0, 10000)
modern_lit_variation = np.random.normal(4.5, 1.8, 10000)

# Chart text elements
suptitle = "Word Length Distribution in Literature"
binslist = [120, 120]
titles = ["Classic Literature", "Modern Literature"]
labels = ["Primary Distribution", "Secondary Distribution"]
xlabel = "Word Length (in characters)"
ylabel = "Frequency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(12, 8), gridspec_kw={"hspace": 0.5})

# Overall title (suptitle)
fig.suptitle(suptitle, fontsize=16)

# Colors and styles
colors = ["#8B4513", "#BC8F8F"]
variance_colors = ["#2E8B57", "#8FBC8F"]

# First histogram (Classic Literature)
axs[0].hist(classic_lit, bins=binslist[0], range=(0, 15), alpha=0.6, label=labels[0], color=colors[0])
axs[0].hist(classic_lit_variation, bins=binslist[0], range=(0, 15), alpha=0.6, label=labels[1], color=colors[1])
axs[0].set_title(titles[0])
axs[0].set_xlabel(xlabel)
axs[0].set_ylabel(ylabel)
axs[0].grid(True, which='both', linestyle='--', linewidth=0.5)
axs[0].legend()

# Second histogram (Modern Literature)
axs[1].hist(modern_lit, bins=binslist[1], range=(0, 15), alpha=0.6, label=labels[0], color=variance_colors[0])
axs[1].hist(modern_lit_variation, bins=binslist[1], range=(0, 15), alpha=0.6, label=labels[1], color=variance_colors[1])
axs[1].set_title(titles[1])
axs[1].set_xlabel(xlabel)
axs[1].set_ylabel(ylabel)
axs[1].grid(True, which='both', linestyle='--', linewidth=0.5)
axs[1].legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout(rect=[0, 0.03, 1, 0.95])  # Adjust the layout to accommodate the overall title

plt.savefig("hist_76.pdf", bbox_inches="tight")
