
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Simulated data for communication standards over distance (in meters)
distance = np.array([0, 20, 40, 60, 80, 100])
signal_strength_4g = np.array([0.9, 0.85, 0.78, 0.65, 0.5, 0.4])  # 4G Signal Strength
signal_strength_5g = np.array([0.95, 0.88, 0.8, 0.7, 0.55, 0.45])  # 5G Signal Strength
signal_strength_wifi = np.array([0.85, 0.75, 0.65, 0.55, 0.45, 0.3])  # Wi-Fi Signal Strength

# Reference Line for Ideal Signal Strengths
ideal_signal_y = [1.0, 1.0]
ideal_signal_x = [-10, 110]

# Axes Limits and Labels
xlabel_value = "Distance (meters)"
xlim_values = [-10, 110]

ylabel_value = "Signal Strength (normalized)"
ylim_values = [0.3, 1.0]
yticks_values = [0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]

# Labels
label_1 = "4G"
label_2 = "5G"
label_3 = "Wi-Fi"
label_4 = "Ideal Signal"

# Titles
title_1 = "Signal Strength over Distance for Various Standards"
title_2 = "Communication Standards"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(8, 6))  # Adjust figure size to match a professional look
plt.plot(distance, signal_strength_4g, label=label_1, color="#1f77b4", marker="o", linestyle="-", linewidth=2)
plt.plot(distance, signal_strength_5g, label=label_2, color="#ff7f0e", marker="s", linestyle="--", linewidth=2)
plt.plot(distance, signal_strength_wifi, label=label_3, color="#2ca02c", marker="^", linestyle=":", linewidth=2)
plt.plot(ideal_signal_x, ideal_signal_y, label=label_4, color="#d62728", linestyle="--", linewidth=1.5)

# Add title and labels
plt.title(title_1, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.xticks(distance)
plt.xlim(xlim_values)
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Add legend with additional entry
plt.legend(title=title_2,loc="upper right")

# Adding a grid with a slightly gray color
plt.grid(color="#e5e5e5", linestyle="-", linewidth=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_102.pdf", bbox_inches="tight")
