
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

import numpy as np

# Simulated economic data
years = [2018, 2019, 2020, 2021, 2022]
gdp_growth = [3.0, 2.8, -3.5, 5.0, 2.5]  # GDP Growth rates in percentage
inflation_rate = [2.1, 1.9, 1.5, 2.3, 2.8]  # Inflation rates in percentage
unemployment_rate = [5.0, 4.8, 8.0, 6.0, 5.5]  # Unemployment rates in percentage

# Extracted variables
line_label_gdp = "GDP Growth Rate"
line_label_inflation = "Inflation Rate"
line_label_unemployment = "Unemployment Rate"
xlim_values = (2018, 2022)
ylim_values = (-4, 10)
xlabel_value = "Year"
ylabel_value = "Percentage (%)"
xticks_values = years
yticks_values = None  # Not explicitly set

# Labels and other textual elements
xtickslabel_fontsize = 14
ytickslabel_fontsize = 14
title_value = "Economic Indicators Over Years"
axhline_value = None  # Not explicitly set in the code
axvline_value = None  # Not explicitly set in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting the lines with enhanced styles
plt.figure(figsize=(10, 6))
plt.plot(
    years,
    gdp_growth,
    marker="o",
    markersize=8,
    linestyle="-.",
    linewidth=2,
    color="#1f77b4",
    label=line_label_gdp,
    clip_on=False,
    zorder=10,
)
plt.plot(
    years,
    inflation_rate,
    marker="s",
    markerfacecolor="white",
    markersize=8,
    linestyle="--",
    linewidth=2,
    markeredgecolor="#ff7f0e",
    color="#ff7f0e",
    clip_on=False,
    zorder=10,
    label=line_label_inflation,
)
plt.plot(
    years,
    unemployment_rate,
    marker="^",
    markerfacecolor="white",
    markersize=8,
    linestyle="-",
    linewidth=2,
    markeredgecolor="#2ca02c",
    color="#2ca02c",
    clip_on=False,
    zorder=10,
    label=line_label_unemployment,
)

# Setting the x-axis and y-axis limits
plt.ylim(*ylim_values)
plt.yticks(fontsize=ytickslabel_fontsize)
plt.xlim(*xlim_values)
plt.xticks(xticks_values, fontsize=xtickslabel_fontsize)

# Adding labels, title, and legend
plt.xlabel(xlabel_value, fontsize=18)
plt.ylabel(ylabel_value, fontsize=18)
plt.title(title_value, fontsize=20, pad=20)

# Adding legend with increased font size
plt.legend(
    fontsize="large",
    loc="upper left",
    frameon=False,
)

# Adding grid
plt.grid(True, alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_104.pdf", bbox_inches="tight")
