
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Variable extraction
line_label_base = "Baseline"
line_label_ours = "Our Model"
xlim_values = (0, 200)
ylim_values_fuel_efficiency = (10, 50)
ylim_values_speed = (40, 120)
ylim_values_engine_temp = (60, 120)
ylim_values_battery_health = (70, 100)
xlabel_value = "Time (minutes)"
ylabel_value_fuel_efficiency = "Fuel Efficiency (MPG)"
ylabel_value_speed = "Vehicle Speed (MPH)"
ylabel_value_engine_temp = "Engine Temperature (°C)"
ylabel_value_battery_health = "Battery Health (%)"
yticks_values_fuel_efficiency = np.arange(10, 51, 10)
yticks_values_speed = np.arange(40, 121, 20)
yticks_values_engine_temp = np.arange(60, 121, 15)
yticks_values_battery_health = np.arange(70, 101, 10)

# Fuel Efficiency
iterations = np.linspace(0, 200, 21)
base_data_fuel_efficiency = np.random.uniform(20, 30, len(iterations))
ours_data_fuel_efficiency = np.random.uniform(30, 40, len(iterations))

# Vehicle Speed
base_data_speed = np.random.uniform(50, 80, len(iterations))
ours_data_speed = np.random.uniform(70, 90, len(iterations))

# Engine Temperature
base_data_engine_temp = np.random.uniform(80, 100, len(iterations))
ours_data_engine_temp = np.random.uniform(90, 110, len(iterations))

# Battery Health
base_data_battery_health = np.random.uniform(75, 85, len(iterations))
ours_data_battery_health = np.random.uniform(85, 95, len(iterations))

# Chart style parameters
legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.15)
legend_frameon = False
legend_ncol = 2
grid_value = True

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Create subplots
fig, axs = plt.subplots(4, 1, figsize=(8, 12))

# Define colors
colors = ['#2ca02c', '#d62728']

# Plotting Fuel Efficiency
axs[0].plot(iterations, base_data_fuel_efficiency, label=line_label_base, color=colors[0], linestyle='--', linewidth=1.5, marker='o')
axs[0].plot(iterations, ours_data_fuel_efficiency, label=line_label_ours, color=colors[1], linestyle='-', linewidth=1.5, marker='x')
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_fuel_efficiency)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_fuel_efficiency)
axs[0].set_yticks(yticks_values_fuel_efficiency)
axs[0].tick_params(axis="both", which="both", color="gray")

# Plotting Vehicle Speed
axs[1].plot(iterations, base_data_speed, label=line_label_base, color=colors[0], linestyle='--', linewidth=1.5, marker='o')
axs[1].plot(iterations, ours_data_speed, label=line_label_ours, color=colors[1], linestyle='-', linewidth=1.5, marker='x')
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_speed)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_speed)
axs[1].set_yticks(yticks_values_speed)
axs[1].tick_params(axis="both", which="both", color="gray")

# Plotting Engine Temperature
axs[2].plot(iterations, base_data_engine_temp, label=line_label_base, color=colors[0], linestyle='--', linewidth=1.5, marker='o')
axs[2].plot(iterations, ours_data_engine_temp, label=line_label_ours, color=colors[1], linestyle='-', linewidth=1.5, marker='x')
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_engine_temp)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_engine_temp)
axs[2].set_yticks(yticks_values_engine_temp)
axs[2].tick_params(axis="both", which="both", color="gray")

# Plotting Battery Health
axs[3].plot(iterations, base_data_battery_health, label=line_label_base, color=colors[0], linestyle='--', linewidth=1.5, marker='o')
axs[3].plot(iterations, ours_data_battery_health, label=line_label_ours, color=colors[1], linestyle='-', linewidth=1.5, marker='x')
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_battery_health)
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(*ylim_values_battery_health)
axs[3].set_yticks(yticks_values_battery_health)
axs[3].tick_params(axis="both", which="both", color="gray")

# Add legends and gridlines to each subplot
for ax in axs.flat:
    ax.legend(
        loc=legend_location,
        bbox_to_anchor=legend_bbox_to_anchor,
        frameon=legend_frameon,
        ncol=legend_ncol,
    )
    ax.grid(grid_value)  # Enable the grid

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("line_108.pdf", bbox_inches="tight")
