
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Variable extraction
line_label_base = "Control Group"
line_label_ours = "Experimental Group"
xlim_values = (0, 200)
ylim_values_accuracy = (50, 100)
ylim_values_engagement = (60, 100)
ylim_values_homework = (60, 100)
ylim_values_quiz = (50, 100)
xlabel_value = "Weeks since start"
ylabel_value_accuracy = "Accuracy (%)"
ylabel_value_engagement = "Engagement (%)"
ylabel_value_homework = "Homework Completion (%)"
ylabel_value_quiz = "Quiz Scores (%)"
yticks_values_accuracy = [50, 60, 70, 80, 90, 100]
yticks_values_engagement = [60, 70, 80, 90, 100]
yticks_values_homework = [60, 70, 80, 90, 100]
yticks_values_quiz = [50, 60, 70, 80, 90, 100]

# Generated education-related data
weeks = np.linspace(0, 200, 21)

# Accuracy Data
base_data_accuracy = np.random.normal(65, 5, 21) + np.linspace(0, 20, 21)
ours_data_accuracy = np.random.normal(70, 5, 21) + np.linspace(0, 25, 21)

# Engagement Data
base_data_engagement = np.random.normal(75, 5, 21) + np.sin(0.1 * weeks) * 5
ours_data_engagement = np.random.normal(80, 5, 21) + np.sin(0.1 * weeks) * 5

# Homework Completion Data
base_data_homework = np.random.normal(70, 5, 21) + np.linspace(0, 20, 21)
ours_data_homework = np.random.normal(75, 5, 21) + np.linspace(0, 25, 21)

# Quiz Scores Data
base_data_quiz = np.random.normal(60, 5, 21) + np.linspace(0, 20, 21)
ours_data_quiz = np.random.normal(65, 5, 21) + np.linspace(0, 25, 21)

legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.2)
legend_frameon = False
legend_ncol = 2
grid_value = True

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Create subplots
fig, axs = plt.subplots(4, 1, figsize=(10, 14))

# Adjust color scheme
colors = {"Control Group": "#1f77b4", "Experimental Group": "#ff7f0e"}

# Plotting Accuracy
axs[0].plot(weeks, base_data_accuracy, label=line_label_base, color=colors[line_label_base], linestyle='-', marker='o')
axs[0].plot(weeks, ours_data_accuracy, label=line_label_ours, color=colors[line_label_ours], linestyle='--', marker='s')
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_accuracy)
axs[0].set_xlim(*xlim_values)
axs[0].set_yticks(yticks_values_accuracy)
axs[0].tick_params(axis="both", which="both", color="gray")

# Plotting Engagement
axs[1].plot(weeks, base_data_engagement, label=line_label_base, color=colors[line_label_base], linestyle='-', marker='o')
axs[1].plot(weeks, ours_data_engagement, label=line_label_ours, color=colors[line_label_ours], linestyle='--', marker='s')
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_engagement)
axs[1].set_xlim(*xlim_values)
axs[1].set_yticks(yticks_values_engagement)
axs[1].tick_params(axis="both", which="both", color="gray")

# Plotting Homework Completion
axs[2].plot(weeks, base_data_homework, label=line_label_base, color=colors[line_label_base], linestyle='-', marker='o')
axs[2].plot(weeks, ours_data_homework, label=line_label_ours, color=colors[line_label_ours], linestyle='--', marker='s')
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_homework)
axs[2].set_xlim(*xlim_values)
axs[2].set_yticks(yticks_values_homework)
axs[2].tick_params(axis="both", which="both", color="gray")

# Plotting Quiz Scores
axs[3].plot(weeks, base_data_quiz, label=line_label_base, color=colors[line_label_base], linestyle='-', marker='o')
axs[3].plot(weeks, ours_data_quiz, label=line_label_ours, color=colors[line_label_ours], linestyle='--', marker='s')
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_quiz)
axs[3].set_xlim(*xlim_values)
axs[3].set_yticks(yticks_values_quiz)
axs[3].tick_params(axis="both", which="both", color="gray")

# Add legends and gridlines to each subplot
for ax in axs.flat:
    ax.legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon, ncol=legend_ncol)
    ax.grid(grid_value)  # Enable the grid

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("line_109.pdf", bbox_inches="tight")
