
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
weeks = [1, 4, 7, 10, 13, 16, 19, 22, 25, 28]
company_a = np.cumsum(np.random.normal(loc=1, scale=0.5, size=len(weeks)))
company_b = np.cumsum(np.random.normal(loc=0.5, scale=0.7, size=len(weeks)))

# Axes Limits and Labels
xlabel_value = "Week"
xlim_values = [1, 28]

ylabel_value = "Stock Price ($)"
ylim_values = [0, max(np.max(company_a), np.max(company_b)) + 5]
yticks_values = np.arange(0, max(np.max(company_a), np.max(company_b)) + 5, 5)

axvspan1_l, axvspan1_r = 10, 19
axvspan2_l, axvspan2_r = 19, 26

# Labels
label_1 = "Company A"
label_2 = "Company B"

# Annotations
annotation_1 = "Market\nsurge"
annotation_2 = "Product\nrelease"
title = "Stock Price Trends of Two Companies Over 28 Weeks"
suptitle = "Economic Data Visualization"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the data
ax.plot(weeks, company_a, "g-^", label=label_1, linestyle="solid", linewidth=2, markersize=8)
ax.plot(weeks, company_b, "b-o", label=label_2, linestyle="dashed", linewidth=2, markersize=6)

# Highlight specific regions
ax.axvspan(axvspan1_l, axvspan1_r, color="lightgreen", alpha=0.3)
ax.axvspan(axvspan2_l, axvspan2_r, color="lightblue", alpha=0.3)

# Annotations
ax.annotate(
    annotation_1,
    xy=(10, company_a[3]),
    xytext=(12, company_a[3] + 5),
    arrowprops=dict(facecolor="green", shrink=0.05),
)
ax.annotate(
    annotation_2,
    xy=(19, company_b[6]),
    xytext=(21, company_b[6] + 5),
    arrowprops=dict(facecolor="blue", shrink=0.05),
)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xticks(weeks)
ax.set_xlim(xlim_values)
ax.set_ylabel(ylabel_value)
ax.set_title(title)
fig.suptitle(suptitle, fontsize=14)

# Add legend
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_110.pdf", bbox_inches="tight")
